/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.hu;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "Falkland-szigeteki z\u00f3naid\u0151",
               "FIST",
               "Falkland-szigeteki ny\u00e1ri id\u0151",
               "FIST",
               "Falkland-szigeteki id\u0151",
               "FIT",
            };
        final String[] Iran = new String[] {
               "Ir\u00e1ni z\u00f3naid\u0151",
               "IST",
               "Ir\u00e1ni ny\u00e1ri id\u0151",
               "IDT",
               "Ir\u00e1ni id\u0151",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "Z\u00f6ld-foki-szigeteki z\u00f3naid\u0151",
               "CVST",
               "Z\u00f6ld-foki-szigeteki ny\u00e1ri id\u0151",
               "CVST",
               "Z\u00f6ld-foki-szigeteki id\u0151",
               "CVT",
            };
        final String[] GMT = new String[] {
               "Greenwichi k\u00f6z\u00e9pid\u0151",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Ponape = new String[] {
               "Ponapei id\u0151",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "Omszki z\u00f3naid\u0151",
               "OST",
               "Omszki ny\u00e1ri id\u0151",
               "OST",
               "Omszki id\u0151",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "Kosraei id\u0151",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-aleuti z\u00f3naid\u0151",
               "HAST",
               "Hawaii-aleuti ny\u00e1ri id\u0151",
               "HADT",
               "Hawaii-aleuti id\u0151",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "Myanmari id\u0151",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalini z\u00f3naid\u0151",
               "SST",
               "Sakhalini ny\u00e1ri id\u0151",
               "SST",
               "Szahalini id\u0151",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Jakutszki z\u00f3naid\u0151",
               "YST",
               "Jakutszki ny\u00e1ri id\u0151",
               "YST",
               "Jakutszki id\u0151",
               "YT",
            };
        final String[] Gambier = new String[] {
               "Gambieri id\u0151",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayi z\u00f3naid\u0151",
               "PST",
               "Paraguayi ny\u00e1ri id\u0151",
               "PST",
               "Paraguayi id\u0151",
               "PT",
            };
        final String[] Nepal = new String[] {
               "Nep\u00e1li id\u0151",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "Mald\u00edv-szigeteki id\u0151",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "T\u00fcrkmeniszt\u00e1ni z\u00f3naid\u0151",
               "TST",
               "T\u00fcrkmeniszt\u00e1ni ny\u00e1ri id\u0151",
               "TST",
               "T\u00fcrkmeniszt\u00e1ni id\u0151",
               "TT",
            };
        final String[] Truk = new String[] {
               "Truki id\u0151",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "Jap\u00e1n z\u00f3naid\u0151",
               "JST",
               "Jap\u00e1n ny\u00e1ri id\u0151",
               "JDT",
               "Jap\u00e1n id\u0151",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Vlagyivosztoki z\u00f3naid\u0151",
               "VST",
               "Vlagyivosztoki ny\u00e1ri id\u0151",
               "VST",
               "Vlagyivosztoki id\u0151",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Nyugat-eur\u00f3pai z\u00f3naid\u0151",
               "WET",
               "Nyugat-eur\u00f3pai ny\u00e1ri id\u0151",
               "WEST",
               "Nyugat-eur\u00f3pai id\u0151",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesi z\u00f3naid\u0151",
               "BST",
               "Bangladesi ny\u00e1ri id\u0151",
               "BST",
               "Bangladesi id\u0151",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "Kelet-timori id\u0151",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "Nyugat-gr\u00f6nlandi z\u00f3naid\u0151",
               "WGST",
               "Nyugat-gr\u00f6nlandi ny\u00e1ri id\u0151",
               "WGST",
               "Nyugat-gr\u00f6nlandi id\u0151",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "Marquesasi id\u0151",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "Kolumbiai z\u00f3naid\u0151",
               "CST",
               "Kolumbiai ny\u00e1ri id\u0151",
               "CST",
               "Kolumbiai id\u0151",
               "CT",
            };
        final String[] Wake = new String[] {
               "Wake-szigeti id\u0151",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Suriname = new String[] {
               "Szurin\u00e1mi id\u0151",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "\u00d6b\u00f6lbeli z\u00f3naid\u0151",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Singapore = new String[] {
               "Szingap\u00fari z\u00f3naid\u0151",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "Hovdi z\u00f3naid\u0151",
               "HST",
               "Hovdi ny\u00e1ri id\u0151",
               "HST",
               "Hovdi id\u0151",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Amaz\u00f3niai z\u00f3naid\u0151",
               "AST",
               "Amaz\u00f3niai ny\u00e1ri id\u0151",
               "AST",
               "Amaz\u00f3niai id\u0151",
               "AT",
            };
        final String[] Tokelau = new String[] {
               "Tokelaui id\u0151",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-szigeteki id\u0151",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Pakistan = new String[] {
               "Pakiszt\u00e1ni z\u00f3naid\u0151",
               "PST",
               "Pakiszt\u00e1ni ny\u00e1ri id\u0151",
               "PST",
               "Pakiszt\u00e1ni id\u0151",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "Ul\u00e1nb\u00e1tori z\u00f3naid\u0151",
               "UBST",
               "Ul\u00e1nb\u00e1tori ny\u00e1ri id\u0151",
               "UBST",
               "Ul\u00e1nb\u00e1tori id\u0151",
               "UBT",
            };
        final String[] Palau = new String[] {
               "Palaui id\u0151",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "\u00daj-kaled\u00f3niai z\u00f3naid\u0151",
               "NCST",
               "\u00daj-kaled\u00f3niai ny\u00e1ri id\u0151",
               "NCST",
               "\u00daj-kaled\u00f3niai id\u0151",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "Naurui id\u0151",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "Csendes-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "PST",
               "Csendes-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "PDT",
               "Csendes-\u00f3ce\u00e1ni id\u0151",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Nyugat-Argent\u00edna z\u00f3naid\u0151",
               "WAST",
               "Nyugat-Argent\u00edna ny\u00e1ri id\u0151",
               "WAST",
               "Nyugat-Argent\u00edna id\u0151",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Galapagosi id\u0151",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "Francia-guianai id\u0151",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Kelet-gr\u00f6nlandi z\u00f3naid\u0151",
               "EGST",
               "Kelet-gr\u00f6nlandi ny\u00e1ri id\u0151",
               "EGST",
               "Kelet-gr\u00f6nlandi id\u0151",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "Kar\u00e1csony-szigeti id\u0151",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "Volgogr\u00e1di z\u00f3naid\u0151",
               "VST",
               "Volgogr\u00e1di ny\u00e1ri id\u0151",
               "VST",
               "Volgogr\u00e1di id\u0151",
               "VT",
            };
        final String[] Korea = new String[] {
               "Koreai z\u00f3naid\u0151",
               "KST",
               "Koreai ny\u00e1ri id\u0151",
               "KDT",
               "Koreai id\u0151",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatui z\u00f3naid\u0151",
               "VST",
               "Vanuatui ny\u00e1ri id\u0151",
               "VST",
               "Vanuatui id\u0151",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Argent\u00edna z\u00f3naid\u0151",
               "AST",
               "Argent\u00ednai ny\u00e1ri id\u0151",
               "AST",
               "Argent\u00ednai id\u0151",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord howei z\u00f3naid\u0151",
               "LHST",
               "Lord howei ny\u00e1ri id\u0151",
               "LHDT",
               "Lord howei id\u0151",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "Syowai id\u0151",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgiz id\u0151",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "Arab z\u00f3naid\u0151",
               "AST",
               "Arab ny\u00e1ri id\u0151",
               "ADT",
               "Arab id\u0151",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ausztr\u00e1l keleti z\u00f3naid\u0151",
               "AEST",
               "Ausztr\u00e1l keleti ny\u00e1ri id\u0151",
               "AEDT",
               "Kelet-ausztr\u00e1l id\u0151",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutszki z\u00f3naid\u0151",
               "IST",
               "Irkutszki ny\u00e1ri id\u0151",
               "IST",
               "Irkutszki id\u0151",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "Mauritiusi z\u00f3naid\u0151",
               "MST",
               "Mauritiusi ny\u00e1ri id\u0151",
               "MST",
               "Mauritiusi id\u0151",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiai-\u00f3ce\u00e1ni id\u0151",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Csojbalszani z\u00f3naid\u0151",
               "CST",
               "Csojbalszani ny\u00e1ri id\u0151",
               "CST",
               "Csojbalszani id\u0151",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Keleti \u00e1llamokbeli z\u00f3naid\u0151",
               "EST",
               "Keleti \u00e1llamokbeli ny\u00e1ri id\u0151",
               "EDT",
               "Keleti \u00e1llamokbeli id\u0151",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "Ausztr\u00e1l nyugati z\u00f3naid\u0151",
               "AWST",
               "Ausztr\u00e1l nyugati ny\u00e1ri id\u0151",
               "AWDT",
               "Nyugat-ausztr\u00e1l id\u0151",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ausztr\u00e1l k\u00f6z\u00e9ps\u0151 nyugati z\u00f3naid\u0151",
               "ACWST",
               "Ausztr\u00e1l k\u00f6z\u00e9ps\u0151 nyugati ny\u00e1ri id\u0151",
               "ACWDT",
               "Ausztr\u00e1l k\u00f6z\u00e9ps\u0151 nyugati id\u0151",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasznojarszki z\u00f3naid\u0151",
               "KST",
               "Krasznojarszki ny\u00e1ri id\u0151",
               "KST",
               "Krasznojarszki id\u0151",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Kelet-indon\u00e9ziai id\u0151",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "Venezuelai id\u0151",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairni id\u0151",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "But\u00e1ni id\u0151",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-i z\u00f3naid\u0151",
               "FNST",
               "Fernando de Noronha-i ny\u00e1ri id\u0151",
               "FNST",
               "Fernando de Noronha-i id\u0151",
               "FNT",
            };
        final String[] Malaysia = new String[] {
               "Malajziai id\u0151",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] Novosibirsk = new String[] {
               "Novoszibirzski z\u00f3naid\u0151",
               "NST",
               "Novoszibirszki ny\u00e1ri id\u0151",
               "NST",
               "Novoszibirszki id\u0151",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Hegyvid\u00e9ki z\u00f3naid\u0151",
               "MST",
               "Hegyvid\u00e9ki ny\u00e1ri id\u0151",
               "MDT",
               "Hegyvid\u00e9ki id\u0151",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk-szigeteki id\u0151",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "Niuei id\u0151",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "Vosztoki id\u0151",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "Alaszkai z\u00f3naid\u0151",
               "AKST",
               "Alaszkai ny\u00e1ri id\u0151",
               "AKDT",
               "Alaszkai id\u0151",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "\u00d6rm\u00e9ny z\u00f3naid\u0151",
               "AST",
               "\u00d6rm\u00e9ny ny\u00e1ri id\u0151",
               "AST",
               "\u00d6rm\u00e9ny id\u0151",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall-szigeteki id\u0151",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "Ausztr\u00e1l k\u00f6z\u00e9ps\u0151 z\u00f3naid\u0151",
               "ACST",
               "Ausztr\u00e1l k\u00f6z\u00e9ps\u0151 ny\u00e1ri id\u0151",
               "ACDT",
               "K\u00f6z\u00e9p-ausztr\u00e1liai id\u0151",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Azori z\u00f3naid\u0151",
               "AST",
               "Azori ny\u00e1ri id\u0151",
               "AST",
               "Azori id\u0151",
               "AT",
            };
        final String[] Reunion = new String[] {
               "R\u00e9unioni id\u0151",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "Indok\u00ednai id\u0151",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "Ecuadori id\u0151",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Magad\u00e1ni z\u00f3naid\u0151",
               "MST",
               "Magad\u00e1ni ny\u00e1ri id\u0151",
               "MST",
               "Magadani id\u0151",
               "MT",
            };
        final String[] Chatham = new String[] {
               "Chathami z\u00f3naid\u0151",
               "CST",
               "Chathami ny\u00e1ri id\u0151",
               "CDT",
               "Chathami id\u0151",
               "CT",
            };
        final String[] Davis = new String[] {
               "Davisi id\u0151",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Kubai z\u00f3naid\u0151",
               "CST",
               "Kubai ny\u00e1ri id\u0151",
               "CDT",
               "Kubai id\u0151",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Nyugat-afrikai z\u00f3naid\u0151",
               "WAST",
               "Nyugat-afrikai ny\u00e1ri id\u0151",
               "WAST",
               "Nyugat-afrikai id\u0151",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Moszkvai z\u00f3naid\u0151",
               "MST",
               "Moszkvai ny\u00e1ri id\u0151",
               "MST",
               "Moszkvai id\u0151",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "P\u00e1pua \u00faj-guineai id\u0151",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Kelet-kazahszt\u00e1ni id\u0151",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "\u00daj-z\u00e9landi z\u00f3naid\u0151",
               "NZST",
               "\u00daj-z\u00e9landi ny\u00e1ri id\u0151",
               "NZDT",
               "\u00daj-z\u00e9landi id\u0151",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongi z\u00f3naid\u0151",
               "HKST",
               "Hongkongi ny\u00e1ri id\u0151",
               "HKST",
               "Hongkongi id\u0151",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Braz\u00edliai z\u00f3naid\u0151",
               "BST",
               "Braz\u00edliai ny\u00e1ri id\u0151",
               "BST",
               "Braz\u00edliai id\u0151",
               "BT",
            };
        final String[] Cocos = new String[] {
               "K\u00f3kusz-szigeteki id\u0151",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "Afganiszt\u00e1ni id\u0151",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Nyugat-indon\u00e9ziai id\u0151",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam-i id\u0151",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix-szigeteki id\u0151",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "Seychelle-szigeteki id\u0151",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "K\u00f6z\u00e9p-afrikai id\u0151",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "H\u00fasv\u00e9t-szigeteki z\u00f3naid\u0151",
               "EIST",
               "H\u00fasv\u00e9t-szigeteki ny\u00e1ri id\u0151",
               "EIST",
               "H\u00fasv\u00e9t-szigeteki id\u0151",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "D\u00e9l-gr\u00faziai id\u0151",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "K\u00f6z\u00e9p-indon\u00e9ziai id\u0151",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "F\u00fcl\u00f6p-szigeteki z\u00f3naid\u0151",
               "PST",
               "F\u00fcl\u00f6p-szigeteki ny\u00e1ri id\u0151",
               "PST",
               "F\u00fcl\u00f6p-szigeteki id\u0151",
               "PT",
            };
        final String[] Georgia = new String[] {
               "Gr\u00faz z\u00f3naid\u0151",
               "GST",
               "Gr\u00faz ny\u00e1ri id\u0151",
               "GST",
               "Gr\u00faz id\u0151",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "Bol\u00edviai id\u0151",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Perui z\u00f3naid\u0151",
               "PST",
               "Perui ny\u00e1ri id\u0151",
               "PST",
               "Perui id\u0151",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "Chamorroi id\u0151",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "\u00daj-fundlandi z\u00f3naid\u0151",
               "NST",
               "\u00daj-fundlandi ny\u00e1ri id\u0151",
               "NDT",
               "\u00daj-fundlandi id\u0151",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "Line-szigeteki id\u0151",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "Cook-szigeteki z\u00f3naid\u0151",
               "CIST",
               "Cook-szigeteki f\u00e9l ny\u00e1ri id\u0151",
               "CIHST",
               "Cook-szigeteki id\u0151",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "K\u00f6z\u00e9ps\u0151 \u00e1llamokbeli z\u00f3naid\u0151",
               "CST",
               "K\u00f6z\u00e9ps\u0151 \u00e1llamokbeli ny\u00e1ri id\u0151",
               "CDT",
               "K\u00f6z\u00e9ps\u0151 \u00e1llamokbeli id\u0151",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Kelet-afrikai id\u0151",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbajdzs\u00e1ni z\u00f3naid\u0151",
               "AST",
               "Azerbajdzs\u00e1ni ny\u00e1ri id\u0151",
               "AST",
               "Azerbajdzs\u00e1ni id\u0151",
               "AT",
            };
        final String[] Guyana = new String[] {
               "Guyanai id\u0151",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekatyerinburgi z\u00f3naid\u0151",
               "YST",
               "Jekatyerinburgi ny\u00e1ri id\u0151",
               "YST",
               "Jekatyerinburgi id\u0151",
               "YT",
            };
        final String[] China = new String[] {
               "K\u00ednai z\u00f3naid\u0151",
               "CST",
               "K\u00ednai ny\u00e1ri id\u0151",
               "CDT",
               "K\u00ednai id\u0151",
               "CT",
            };
        final String[] Samoa = new String[] {
               "Szamoai z\u00f3naid\u0151",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "Tongai z\u00f3naid\u0151",
               "TST",
               "Tongai ny\u00e1ri id\u0151",
               "TST",
               "Tongai id\u0151",
               "TT",
            };
        final String[] Solomon = new String[] {
               "Salamon-szigeteki id\u0151",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "D\u00e9l-afrikai id\u0151",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie-i id\u0151",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "Francia d\u00e9li \u00e9s antarktikus id\u0151",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "Chilei z\u00f3naid\u0151",
               "CST",
               "Chilei ny\u00e1ri id\u0151",
               "CST",
               "Chilei id\u0151",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Nyugat-kazahszt\u00e1ni id\u0151",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Izraeli z\u00f3naid\u0151",
               "IST",
               "Izraeli ny\u00e1ri id\u0151",
               "IDT",
               "Izraeli id\u0151",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "Tadzsikiszt\u00e1ni id\u0151",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tahiti = new String[] {
               "Tahiti id\u0151",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "Mawsoni id\u0151",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre \u00e9s Miquelon-i z\u00f3naid\u0151",
               "PMST",
               "Pierre \u00e9s Miquelon-i ny\u00e1ri id\u0151",
               "PMDT",
               "Pierre \u00e9s Miquelon-i id\u0151",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "Fidzsi z\u00f3naid\u0151",
               "FST",
               "Fidzsi ny\u00e1ri id\u0151",
               "FST",
               "Fidzsi id\u0151",
               "FT",
            };
        final String[] Rothera = new String[] {
               "Rotherai id\u0151",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "K\u00f6z\u00e9p-eur\u00f3pai z\u00f3naid\u0151",
               "CET",
               "K\u00f6z\u00e9p-eur\u00f3pai ny\u00e1ri id\u0151",
               "CEST",
               "K\u00f6z\u00e9p-eur\u00f3pai id\u0151",
               "CET",
            };
        final String[] India = new String[] {
               "Indiai z\u00f3naid\u0151",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d'Urville-i id\u0151",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "Wallis \u00e9s futunai id\u0151",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalui id\u0151",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Uzbekistan = new String[] {
               "\u00dczbegiszt\u00e1ni z\u00f3naid\u0151",
               "UST",
               "\u00dczbegiszt\u00e1ni ny\u00e1ri id\u0151",
               "UST",
               "\u00dczbegiszt\u00e1ni id\u0151",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "Kelet-eur\u00f3pai z\u00f3naid\u0151",
               "EET",
               "Kelet-eur\u00f3pai ny\u00e1ri id\u0151",
               "EEST",
               "Kelet-eur\u00f3pai id\u0151",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Atlanti-\u00f3ce\u00e1ni z\u00f3naid\u0151",
               "AST",
               "Atlanti-\u00f3ce\u00e1ni ny\u00e1ri id\u0151",
               "ADT",
               "Atlanti-\u00f3ce\u00e1ni id\u0151",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "Uruguayi z\u00f3naid\u0151",
               "UST",
               "Uruguayi ny\u00e1ri id\u0151",
               "UST",
               "Uruguayi id\u0151",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Africa/Malabo", Africa_Western },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Africa/Ouagadougou", GMT },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "Africa/Dakar", GMT },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Africa/Bissau", GMT },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Lima", Peru },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Europe/Guernsey", GMT },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Monrovia", GMT },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Jersey", GMT },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Pacific/Wallis", Wallis },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Nome", Alaska },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Wake", Wake },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Africa/Accra", GMT },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Dushanbe", Tajikistan },
            { "Europe/Isle_of_Man", GMT },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Africa/Abidjan", GMT },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Banjul", GMT },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "Africa/Conakry", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
