/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.da;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_da extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Falkland = new String[] {
               "Falklands\u00f8erne-normaltid",
               "FIST",
               "Falklands\u00f8erne-sommertid",
               "FIST",
               "Falklands\u00f8erne-tid",
               "FIT",
            };
        final String[] Iran = new String[] {
               "Iransk normaltid",
               "IST",
               "Iransk sommertid",
               "IDT",
               "Iransk tid",
               "IT",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdisk normaltid",
               "CVST",
               "Kapverdisk sommertid",
               "CVST",
               "Kapverdisk tid",
               "CVT",
            };
        final String[] Ponape = new String[] {
               "Ponape-tid",
               "PT",
               "Ponape Summer Time",
               "PST",
               "Ponape Time",
               "PT",
            };
        final String[] Omsk = new String[] {
               "Omsk-normaltid",
               "OST",
               "Omsk-sommertid",
               "OST",
               "Omsk-tid",
               "OT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-tid",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian-normaltid",
               "HAST",
               "Hawaii-Aleutian-sommertid",
               "HADT",
               "Hawaii-Aleutian-tid",
               "HAT",
            };
        final String[] Myanmar = new String[] {
               "Myanmarsk tid",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin-normaltid",
               "SST",
               "Sakhalin-sommertid",
               "SST",
               "Sakhalin-tid",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk-normaltid",
               "YST",
               "Yakutsk-sommertid",
               "YST",
               "Yakutsk-tid",
               "YT",
            };
        final String[] Gambier = new String[] {
               "Gambier-tid",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayansk normaltid",
               "PST",
               "Paraguayansk sommertid",
               "PST",
               "Paraguayansk tid",
               "PT",
            };
        final String[] Nepal = new String[] {
               "Nepalesisk tid",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Maldives = new String[] {
               "Maldivisk tid",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmensk normaltid",
               "TST",
               "Turkmensk sommertid",
               "TST",
               "Turkmensk tid",
               "TT",
            };
        final String[] Truk = new String[] {
               "Truk-tid",
               "CT",
               "Chuuk Summer Time",
               "CST",
               "Chuuk Time",
               "CT",
            };
        final String[] Japan = new String[] {
               "Japansk normaltid",
               "JST",
               "Japansk sommertid",
               "JDT",
               "Japansk tid",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok-normaltid",
               "VST",
               "Vladivostok-sommertid",
               "VST",
               "Vladivostok-tid",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Vesteurop\u00e6isk normaltid",
               "WET",
               "Vesteurop\u00e6isk sommertid",
               "WEST",
               "Vesteurop\u00e6isk tid",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "Bangladeshisk normaltid",
               "BST",
               "Bangladeshisk sommertid",
               "BST",
               "Bangladeshisk tid",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "\u00d8sttimor-normaltid",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "Vestgr\u00f8nlandsk normaltid",
               "WGST",
               "Vestgr\u00f8nlandsk sommertid",
               "WGST",
               "Vestgr\u00f8nlandsk tid",
               "WGT",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-tid",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Colombia = new String[] {
               "Colombiansk normaltid",
               "CST",
               "Colombiansk sommertid",
               "CST",
               "Colombiansk tid",
               "CT",
            };
        final String[] Wake = new String[] {
               "Wake\u00f8en-tid",
               "WIT",
               "Wake Island Summer Time",
               "WIST",
               "Wake Island Time",
               "WIT",
            };
        final String[] Suriname = new String[] {
               "Surinam-tid",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Gulf = new String[] {
               "Golflandene-normaltid",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Singapore = new String[] {
               "Singaporeansk normaltid",
               "SST",
               "Singapore Daylight Time",
               "SDT",
               "Singapore Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "Hovd-normaltid",
               "HST",
               "Hovd-sommertid",
               "HST",
               "Hovd-tid",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Amazonas-normaltid",
               "AST",
               "Amazonas-sommertid",
               "AST",
               "Amazonas-tid",
               "AT",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-tid",
               "TT",
               "Tokelau Summer Time",
               "TST",
               "Tokelau Time",
               "TT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert\u00f8erne-tid",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] Pakistan = new String[] {
               "Pakistansk normaltid",
               "PST",
               "Pakistansk sommertid",
               "PST",
               "Pakistansk tid",
               "PT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator-normaltid",
               "UBST",
               "Ulan Bator-sommertid",
               "UBST",
               "Ulan Bator-tid",
               "UBT",
            };
        final String[] Palau = new String[] {
               "Palau-normaltid",
               "PT",
               "Palau Summer Time",
               "PST",
               "Palau Time",
               "PT",
            };
        final String[] New_Caledonia = new String[] {
               "Nykaledonsk normaltid",
               "NCST",
               "Nykaledonsk sommertid",
               "NCST",
               "Nykaledonsk tid",
               "NCT",
            };
        final String[] Nauru = new String[] {
               "Nauru-tid",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] America_Pacific = new String[] {
               "Pacific-normaltid",
               "PST",
               "Pacific-sommertid",
               "PDT",
               "Pacific-tid",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Vestargentinsk normaltid",
               "WAST",
               "Vestargentinsk sommertid",
               "WAST",
               "Vestargentinsk tid",
               "WAT",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-tid",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] French_Guiana = new String[] {
               "Fransk Guiana-tid",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u00d8stgr\u00f8nlandsk normaltid",
               "EGST",
               "\u00d8stgr\u00f8nlandsk sommertid",
               "EGST",
               "\u00d8stgr\u00f8nlandsk tid",
               "EGT",
            };
        final String[] Christmas = new String[] {
               "Jule\u00f8en-normaltid",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Volgograd = new String[] {
               "Volgograd-normaltid",
               "VST",
               "Volgograd-sommertid",
               "VST",
               "Volgograd-tid",
               "VT",
            };
        final String[] Korea = new String[] {
               "Koreansk normaltid",
               "KST",
               "Koreansk sommertid",
               "KDT",
               "Koreansk tid",
               "KT",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-normaltid",
               "VST",
               "Vanuatu-sommertid",
               "VST",
               "Vanuatu-tid",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Argentinsk normaltid",
               "AST",
               "Argentinsk sommertid",
               "AST",
               "Argentisk tid",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe-normaltid",
               "LHST",
               "Lord Howe-sommertid",
               "LHDT",
               "Lord Howe-tid",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "Syowa-tid",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisisk tid",
               "KT",
               "Kyrgystan Summer Time",
               "KST",
               "Kyrgystan Time",
               "KT",
            };
        final String[] Arabian = new String[] {
               "Arabisk normaltid",
               "AST",
               "Arabisk sommertid",
               "ADT",
               "Arabisk tid",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00d8staustralsk normaltid",
               "AEST",
               "\u00d8staustralsk sommertid",
               "AEDT",
               "\u00d8staustralsk tid",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-normaltid",
               "IST",
               "Irkutsk-sommertid",
               "IST",
               "Irkutsk-tid",
               "IT",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-normaltid",
               "MST",
               "Mauritius-sommertid",
               "MST",
               "Mauritius-tid",
               "MT",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiske Ocean-normaltid",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsan-normaltid",
               "CST",
               "Choibalsan-sommertid",
               "CST",
               "Choibalsan-tid",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern-normaltid",
               "EST",
               "Eastern-sommertid",
               "EDT",
               "Eastern-tid",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "Vestaustralsk normaltid",
               "AWST",
               "Vestaustralsk sommertid",
               "AWDT",
               "Vestaustralsk tid",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Vestlig centralaustralsk normaltid",
               "ACWST",
               "Vestlig centralaustralsk sommertid",
               "ACWDT",
               "Vestlig centralaustralsk tid",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk-normaltid",
               "KST",
               "Krasnoyarsk-sommertid",
               "KST",
               "Krasnoyarsk-tid",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00d8stindonesisk tid",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "Venezuelansk tid",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairn-tid",
               "PT",
               "Pitcairn Summer Time",
               "PST",
               "Pitcairn Time",
               "PT",
            };
        final String[] Bhutan = new String[] {
               "Bhutanesisk tid",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha-normaltid",
               "FNST",
               "Fernando de Noronha-sommertid",
               "FNST",
               "Fernando de Noronha-tid",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk normaltid",
               "NST",
               "Novosibirsk sommertid",
               "NST",
               "Novosibirsk tid",
               "NT",
            };
        final String[] Malaysia = new String[] {
               "Malaysisk tid",
               "MT",
               "Malaysia Summer Time",
               "MST",
               "Malaysia Time",
               "MT",
            };
        final String[] America_Mountain = new String[] {
               "Mountain-normaltid",
               "MST",
               "Mountain-sommertid",
               "MDT",
               "Mountain-tid",
               "MT",
            };
        final String[] Norfolk = new String[] {
               "Norfolk\u00f8en-tid",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Niue = new String[] {
               "Niue-tid",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Vostok = new String[] {
               "Vostok-tid",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "Alaska-normaltid",
               "AKST",
               "Alaska-sommertid",
               "AKDT",
               "Alaska-tid",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "Armensk normaltid",
               "AST",
               "Armensk sommertid",
               "AST",
               "Armensk tid",
               "AT",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall\u00f8erne-tid",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Australia_Central = new String[] {
               "Centralaustralsk normaltid",
               "ACST",
               "Centralaustralsk sommertid",
               "ACDT",
               "Centralaustralsk tid",
               "CAT",
            };
        final String[] Azores = new String[] {
               "Azorerne-normaltid",
               "AST",
               "Azorerne-sommertid",
               "AST",
               "Azorerne-tid",
               "AT",
            };
        final String[] Reunion = new String[] {
               "Reunion-tid",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Indochina = new String[] {
               "Indokinesisk normaltid",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Ecuador = new String[] {
               "Ecuadoriansk tid",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Magadan-normaltid",
               "MST",
               "Magadan-sommertid",
               "MST",
               "Magadan-tid",
               "MT",
            };
        final String[] Chatham = new String[] {
               "Chatham-normaltid",
               "CST",
               "Chatham-sommertid",
               "CDT",
               "Chatham-tid",
               "CT",
            };
        final String[] Davis = new String[] {
               "Davis-tid",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Cubansk normaltid",
               "CST",
               "Cubansk sommertid",
               "CDT",
               "Cubansk tid",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Vestafrikansk normaltid",
               "WAST",
               "Vestafrikansk sommertid",
               "WAST",
               "Vestafrikansk tid",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Moskovitisk normaltid",
               "MST",
               "Moskovitisk sommertid",
               "MST",
               "Moskovitisk tid",
               "MT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua Ny Guinea-tid",
               "PNGT",
               "Papua New Guinea Summer Time",
               "PNGST",
               "Papua New Guinea Time",
               "PNGT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u00d8stkasakhstansk tid",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] New_Zealand = new String[] {
               "Newzealandsk normaltid",
               "NZST",
               "Newzealandsk sommertid",
               "NZDT",
               "Newzealandsk tid",
               "NZT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkong-normaltid",
               "HKST",
               "Hongkong-sommertid",
               "HKST",
               "Hongkong-tid",
               "HKT",
            };
        final String[] Brasilia = new String[] {
               "Brasiliansk normaltid",
               "BST",
               "Brasiliansk sommertid",
               "BST",
               "Brasiliansk tid",
               "BT",
            };
        final String[] Taipei = new String[] {
               "Taipei-normaltid",
               "TST",
               "Taipei-sommertid",
               "TDT",
               "Taipei-tid",
               "TT",
            };
        final String[] Cocos = new String[] {
               "Cocos\u00f8erne-normaltid",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Afghanistan = new String[] {
               "Afghansk tid",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestindonesisk tid",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam-tid",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenix\u00f8en-tid",
               "PIT",
               "Phoenix Islands Summer Time",
               "PIST",
               "Phoenix Islands Time",
               "PIT",
            };
        final String[] Seychelles = new String[] {
               "Seychellisk tid",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Africa_Central = new String[] {
               "Centralafrikansk tid",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Easter = new String[] {
               "P\u00e5ske\u00f8en-normaltid",
               "EIST",
               "P\u00e5ske\u00f8en-sommertid",
               "EIST",
               "P\u00e5ske\u00f8en-tid",
               "EIT",
            };
        final String[] South_Georgia = new String[] {
               "South Georgia-tid",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centralindonesisk tid",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Philippines = new String[] {
               "Filippinsk normaltid",
               "PST",
               "Filippinsk sommertid",
               "PST",
               "Filippinsk tid",
               "PT",
            };
        final String[] Georgia = new String[] {
               "Georgiansk normaltid",
               "GST",
               "Georgiansk sommertid",
               "GST",
               "Georgiansk tid",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "Boliviansk tid",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Peruviansk normaltid",
               "PST",
               "Peruviansk sommertid",
               "PST",
               "Peruviansk tid",
               "PT",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-tid",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandsk normaltid",
               "NST",
               "Newfoundlandsk sommertid",
               "NDT",
               "Newfoundlandsk tid",
               "NT",
            };
        final String[] Line_Islands = new String[] {
               "Linje\u00f8erne-tid",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Cook = new String[] {
               "Cook\u00f8erne-normaltid",
               "CIST",
               "Cook\u00f8erne-sommertid",
               "CIHST",
               "Cook\u00f8erne-tid",
               "CIT",
            };
        final String[] America_Central = new String[] {
               "Central-normaltid",
               "CST",
               "Central-sommertid",
               "CDT",
               "Central-tid",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00d8stafrikansk tid",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbajdsjansk normaltid",
               "AST",
               "Aserbajdsjansk sommertid",
               "AST",
               "Aserbajdsjansk tid",
               "AT",
            };
        final String[] Guyana = new String[] {
               "Guyana-tid",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburgsk normaltid",
               "YST",
               "Yekaterinburgsk sommertid",
               "YST",
               "Yekaterinburgsk tid",
               "YT",
            };
        final String[] China = new String[] {
               "Kinesisk normaltid",
               "CST",
               "Kinesisk sommertid",
               "CDT",
               "Kinesisk tid",
               "CT",
            };
        final String[] Samoa = new String[] {
               "Samoa-normaltid",
               "SST",
               "Samoa Daylight Time",
               "SDT",
               "Samoa Time",
               "ST",
            };
        final String[] Tonga = new String[] {
               "Tongansk normaltid",
               "TST",
               "Tongansk sommertid",
               "TST",
               "Tongansk tid",
               "TT",
            };
        final String[] Solomon = new String[] {
               "Salomon\u00f8erne-tid",
               "SIT",
               "Solomon Islands Summer Time",
               "SIST",
               "Solomon Islands Time",
               "SIT",
            };
        final String[] Africa_Southern = new String[] {
               "Sydafrikansk tid",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie tid",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] French_Southern = new String[] {
               "Franske Sydlige og Antarktiske Territorier-tid",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] Chile = new String[] {
               "Chilensk normaltid",
               "CST",
               "Chilensk sommertid",
               "CST",
               "Chilensk tid",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Vestkasakhstansk tid",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Israelsk normaltid",
               "IST",
               "Israelsk sommertid",
               "IDT",
               "Israelsk tid",
               "IT",
            };
        final String[] Tajikistan = new String[] {
               "Tadsjikisk tid",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Tahiti = new String[] {
               "Tahitisk tid",
               "TT",
               "Tahiti Summer Time",
               "TST",
               "Tahiti Time",
               "TT",
            };
        final String[] Mawson = new String[] {
               "Mawson-tid",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierre- og Miquelon-normaltid",
               "PMST",
               "Pierre- og Miquelon-sommertid",
               "PMDT",
               "Pierre- og Miquelon-tid",
               "PMT",
            };
        final String[] Fiji = new String[] {
               "Fijiansk normaltid",
               "FST",
               "Fijiansk sommertid",
               "FST",
               "Fijiansk tid",
               "FT",
            };
        final String[] Rothera = new String[] {
               "Rothera-tid",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "Mellemeurop\u00e6isk normaltid",
               "CET",
               "Mellemeurop\u00e6isk sommertid",
               "CEST",
               "Mellemeurop\u00e6isk tid",
               "CET",
            };
        final String[] India = new String[] {
               "Indisk normaltid",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d'Urville-tid",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Wallis = new String[] {
               "Wallis og Futuna-tid",
               "WFT",
               "Wallis and Futuna Summer Time",
               "WFST",
               "Wallis and Futuna Time",
               "WFT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-tid",
               "TT",
               "Tuvalu Summer Time",
               "TST",
               "Tuvalu Time",
               "TT",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekisk normaltid",
               "UST",
               "Usbekisk sommertid",
               "UST",
               "Usbekisk tid",
               "UT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00d8steurop\u00e6isk normaltid",
               "EET",
               "\u00d8steurop\u00e6isk sommertid",
               "EEST",
               "\u00d8steurop\u00e6isk tid",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Atlantic-normaltid",
               "AST",
               "Atlantic-sommertid",
               "ADT",
               "Atlantic-tid",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "Uruguayansk normaltid",
               "UST",
               "Uruguayansk sommertid",
               "UST",
               "Uruguayansk tid",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "Asia/Bangkok", Indochina },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Katmandu", Nepal },
            { "America/Resolute", America_Central },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Pacific/Rarotonga", Cook },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Guam", Chamorro },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vientiane", Indochina },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Indian/Reunion", Reunion },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "Asia/Kuching", Malaysia },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Asia/Tashkent", Uzbekistan },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "Indian/Cocos", Cocos },
            { "America/Glace_Bay", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Mauritius", Mauritius },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Pacific/Auckland", New_Zealand },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Pacific/Norfolk", Norfolk },
            { "Asia/Irkutsk", Irkutsk },
            { "Pacific/Apia", Samoa },
            { "Pacific/Chatham", Chatham },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Asia/Baghdad", Arabian },
            { "Pacific/Saipan", Chamorro },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Singapore", Singapore },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Pacific/Funafuti", Tuvalu },
            { "Asia/Taipei", Taipei },
            { "Pacific/Majuro", Marshall_Islands },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Lima", Peru },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Rome", Europe_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Tehran", Iran },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Pacific/Kiritimati", Line_Islands },
            { "Asia/Yakutsk", Yakutsk },
            { "Indian/Mahe", Seychelles },
            { "America/Panama", America_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "Asia/Muscat", Gulf },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Pacific/Guadalcanal", Solomon },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Pago_Pago", Samoa },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Asia/Saigon", Indochina },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Nauru", Nauru },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "Pacific/Galapagos", Galapagos },
            { "America/Monterrey", America_Central },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "Indian/Christmas", Christmas },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Pacific/Niue", Niue },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Tahiti", Tahiti },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "Pacific/Truk", Truk },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Asia/Karachi", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "Pacific/Wallis", Wallis },
            { "America/Nome", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Wake", Wake },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Dubai", Gulf },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "Atlantic/Azores", Azores },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Jamaica", America_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Pitcairn", Pitcairn },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "Asia/Kabul", Afghanistan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Asia/Rangoon", Myanmar },
            { "America/Jujuy", Argentina },
            { "Asia/Calcutta", India },
            { "America/Buenos_Aires", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Gambier", Gambier },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "Pacific/Easter", Easter },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "Pacific/Fakaofo", Tokelau },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "Pacific/Kosrae", Kosrae },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Pacific/Tongatapu", Tonga },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Manila", Philippines },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Asia/Samarkand", Uzbekistan },
            { "Pacific/Fiji", Fiji },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Midway", Samoa },
            { "Pacific/Palau", Palau },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
